% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation_structure.R
\name{fit_graph_to_Theta}
\alias{fit_graph_to_Theta}
\title{Experimental: Fit graph using empirical Theta matrix}
\usage{
fit_graph_to_Theta(data, m = NULL, Gamma_emp = NULL)
}
\arguments{
\item{data}{The (standardized) data from which to compute Gamma}

\item{m}{The number of edges to add, defaults to the number of edges in a tree}

\item{Gamma_emp}{The empirical Gamma matrix
(can be \code{NULL} if \code{data} is given)}
}
\value{
A list containing an [\code{igraph::graph}] object and a fitted \code{Gamma} matrix
}
\description{
Fits a graph to an empirical Gamma matrix by computing the corresponding
Theta matrix using \code{\link[=Gamma2Theta]{Gamma2Theta()}} and greedily chooses \code{m} edges that
correspond to high absolute values in Theta.
}
\seealso{
Other structure estimation methods:
\code{\link{data2mpareto}()},
\code{\link{eglatent}()},
\code{\link{eglearn}()},
\code{\link{emst}()}
}
\concept{structureEstimation}
