% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_completions_general.R
\name{complete_Gamma_general_split}
\alias{complete_Gamma_general_split}
\title{Non-decomposable completion of variogram matrices}
\usage{
complete_Gamma_general_split(
  Gamma,
  graph,
  N = 10000,
  sub_tol = get_large_tol() * 0.001,
  check_tol = 100,
  mc_cores_overwrite = NULL,
  final_tol = get_large_tol()
)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{graph}{\code{igraph::graph()} object.}

\item{N}{Maximum number of iterations.}

\item{sub_tol}{Numeric scalar. Tolerance to be used when completing submatrices.
Should be smaller than \code{final_tol}.}

\item{check_tol}{Numeric/integer scalar. How often to check the tolerance when completing submatrices.}

\item{mc_cores_overwrite}{\code{NULL} or numeric/integer scalar. Maximal number of cores to use.}

\item{final_tol}{Numeric scalar. Check convergence of the final result with this tolerance.
Skipped if this value is < 0.}
}
\value{
A completed \dxd variogram matrix.
}
\description{
Given a non-decomposable \code{graph}, and (non-graphical) variogram matrix \code{Gamma},
modifies \code{Gamma} in non-edge entries, such that the resulting matrix is a
variogram matrix with graphical structure described by \code{graph}.
Does so by splitting \code{graph} at complete separators into smaller subgraphs,
and calling \code{complete_Gamma_general} for each subgraph/submatrix,
using multiple cores if available.
}
\seealso{
Other Matrix completions: 
\code{\link{complete_Gamma_decomposable}()},
\code{\link{complete_Gamma_general_demo}()},
\code{\link{complete_Gamma_general}()},
\code{\link{complete_Gamma}()}
}
\concept{Matrix completions}
