% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checks.R
\name{check_Gamma_and_graph}
\alias{check_Gamma_and_graph}
\title{Check input graph and Gamma matrix}
\usage{
check_Gamma_and_graph(Gamma, graph = NULL, graph_type = "general")
}
\arguments{
\item{Gamma}{A Gamma matrix or vector of entries corresponding to the edges
of \code{graph}}

\item{graph}{A graph object or \code{NULL} if the graph structure is specified by
\code{NA} in the Gamma matrix}

\item{graph_type}{Passed to \code{\link[=check_graph]{check_graph()}}.}
}
\value{
A list consisting of
\item{\code{Gamma}}{The Gamma matrix given as input or implied by the input}
\item{\code{graph}}{The graph given as input or implied by the input}
Throws an error if the input is not valid.
}
\description{
Checks and converts the (incomplete) Gamma matrix and graph given for a
HR graphical model.
}
\seealso{
Other Input checks: 
\code{\link{check_graph}()}
}
\concept{Input checks}
