% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_estimation_functions.R
\name{logdVK_HR}
\alias{logdVK_HR}
\title{Compute censored exponent measure}
\usage{
logdVK_HR(x, K, par)
}
\arguments{
\item{x}{Numeric vector with \eqn{d} positive elements
where the censored exponent measure is to be evaluated.}

\item{K}{Integer vector, subset of \eqn{\{1, \dots, d\}}{{1, ..., d}}.
The index set that is not censored.}

\item{par}{Numeric vector with
\eqn{\frac{d(d - 1)}{2}}{d x (d - 1) / 2} elements.
It represents the upper triangular portion of a
variogram matrix \eqn{\Gamma}.}
}
\value{
Numeric. The censored exponent measure of the HR distribution.
}
\description{
Computes the censored exponent measure density of HR distribution.
}
