% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEdges.R
\name{getEdges}
\alias{getEdges}
\title{getEdges}
\usage{
getEdges(data, tweets, source, str.length = NULL, ...)
}
\arguments{
\item{data}{\code{data.frame} of tweets, typically returned by 
\code{\link[twitteR]{searchTwitter}}, required}

\item{tweets}{Column name of tweets within \code{data}, must be a 
\code{character} string, required.}

\item{source}{User names or ID column of \code{tweets} author, must be a 
\code{character} string, required.}

\item{str.length}{Defaults to \code{NULL}. Shorten length of @tags 
(see details), to a maximum number of characters, optional.}

\item{...}{Any other columns to be passed on to the edges.}
}
\description{
Builds a table of edges (source, target) from a list of tweets 
by subsetting @tags from the text.
}
\details{
The edges function takes in a data frame of tweets, typically 
obtained from the twitter Search or Streaming API, scrapes the content of 
tweets to subset the @tags subsequently forming a table of edges. @tags 
are subsets of regular expressions between at-signs (@) and first 
space (" "). 
Note that the table of edges returned is meant for a directed graph.
Node labels can be shortened using the strLength parameters. 
This is useful for non-latin alphabet where nodes may be wrongly identified.
}
\examples{
\dontrun{
# load twitteR
library(twitteR)

# authenticate
token <- setup_twitter_oauth(consumer_key, consumer_secret, 
                             access_token=NULL, access_secret=NULL)
                             
# search tweets
tweets <- searchTwitter("rstats", n = 200)

# unlist to data.frame
tweets <- twListToDF(tweets)

# get edges
edges <- getEdges(data = tweets, tweets = "text", source = "screenName")

# get edges with coordinates
edges <- getEdges(data = tweets, tweets = "text", source = "screenName", 
                  "longitude", "latitude")
                  
# load igraph
library(igraph)

# plot
g <- graph.data.frame(edges, directed=TRUE)

plot(g)
}

}
\author{
John Coene \email{john.coene@gmail.com}
}
\seealso{
\href{http://cran.r-project.org/web/packages/twitteR/twitteR.pdf}{twitteR} 
and \href{http://cran.r-project.org/web/packages/streamR/streamR.pdf}{streamR} packages wherefrom the data (tweets_df) can be obtained.
}

