% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers-utils.R
\name{gpuInfo}
\alias{gpuInfo}
\alias{cpuInfo}
\title{Device Information}
\usage{
gpuInfo(device_idx = NULL, context_idx = currentContext())

cpuInfo(device_idx = NULL, context_idx = currentContext())
}
\arguments{
\item{device_idx}{An integer value indicating which device to query.}

\item{context_idx}{An integer value indicating which context to query.}
}
\value{
\item{deviceName}{Device Name}

\item{deviceVendor}{Device Vendor}

\item{numberOfCores}{Number of Computing Units 
 (which execute the work groups)}

\item{maxWorkGroupSize}{Maximum number of work items
 per group}

\item{maxWorkItemDim}{Number of dimensions}

\item{maxWorkItemSizes}{Maximum number of works items
 per dimension}

\item{deviceMemory}{Global amount of memory (bytes)}

\item{clockFreq}{Maximum configured clock frequency of the 
device in MHz}

\item{localMem}{Maximum amount of local memory for each work 
group (bytes)}

\item{maxAllocatableMem}{Maximum amount of memory in a single 
piece (bytes)}

\item{available}{Whether the device is available}

\item{deviceExtensions}{OpenCL device extensions available}

\item{double_support}{Logical value if double type supported}
}
\description{
Get basic information about selected device (e.g. GPU)
}
\seealso{
\link{detectPlatforms} \link{detectGPUs} \link{detectCPUs} \link{cpuInfo}
}
\author{
Charles Determan Jr.
}
