% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/template.R
\name{gce_vm_template}
\alias{gce_vm_template}
\title{Create a template container VM}
\usage{
gce_vm_template(template = c("rstudio", "shiny", "opencpu", "r-base",
  "example", "dynamic", "ropensci"), username = NULL, password = NULL,
  dynamic_image = NULL, image_family = "cos-stable", ...)
}
\arguments{
\item{template}{The template available}

\item{username}{username if needed (RStudio)}

\item{password}{password if needed (RStudio)}

\item{dynamic_image}{Supply an alternative to the default Docker image here to download}

\item{image_family}{An image-family.  It must come from the \code{cos-cloud} family.}

\item{...}{Arguments passed on to \code{gce_vm_container}
\describe{
  \item{file}{file location of a cloud-init file. One of \code{file} or \code{cloud_init} must be supplied}
  \item{cloud_init}{contents of a cloud-init file, for example read via \code{readChar(file, nchars = 32768)}}
  \item{image_family}{An image-family.  It must come from the \code{google-containers} family.}
}}
}
\value{
The VM object
}
\description{
This lets you specify templates for the VM you want to launch
It passes the template on to \link{gce_vm_container}
}
\details{
Templates available are:

\itemize{
  \item rstudio An RStudio server docker image with tidyverse and devtools
  \item shiny A Shiny docker image
  \item opencpu An OpenCPU docker image
  \item r_base Latest version of R stable
  \item ropensci RStudio and tidyverse with all ropensci packages on CRAN and Github
  \item example A non-R test container running busybox
  \item dynamic Supply your own docker image to download such as \code{rocker/verse}
 }
 
 For \code{dynamic} templates you will need to launch the docker image with any ports you want opened, 
   other settings etc. via \link{docker_run}.

Use \code{dynamic_image} to override the default rocker images e.g. \code{rocker/shiny} for shiny, etc.
}
\examples{

\dontrun{

 library(googleComputeEngineR)
 
 ## make instance using R-base
 vm <- gce_vm_template("r-base", predefined_type = "f1-micro", name = "rbase")
 
 ## run an R function on the instance within the R-base docker image
 docker_run(vm, "rocker/r-base", c("Rscript", "-e", "1+1"), user = "mark")
 #> [1] 2
 

}


}
