% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vms.R
\name{gce_vm_stop}
\alias{gce_vm_stop}
\title{Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time.}
\usage{
gce_vm_stop(instance, project = gce_get_global_project(),
  zone = gce_get_global_zone())
}
\arguments{
\item{instance}{Name of the instance resource, or an instance object e.g. from \link{gce_get_instance}}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}}

\item{zone}{The name of the zone for this request, default as set by \link{gce_get_global_zone}}
}
\description{
Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}

Stopped instances do not incur per-minute, virtual machine usage charges 
  while they are stopped, but any resources that the virtual machine is using, 
  such as persistent disks and static IP addresses, 
  will continue to be charged until they are deleted.
}
\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}

