% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement_protocol.R
\name{ga_trackme}
\alias{ga_trackme}
\alias{ga_trackme_event}
\title{Opt in or out of googleAnalyticsR usage tracking}
\usage{
ga_trackme()

ga_trackme_event(debug_call = FALSE, say_hello = NULL)
}
\arguments{
\item{debug_call}{Set as a debug event to see what would be sent}

\item{say_hello}{If you want to add your own custom message to the event sent, add it here!}
}
\description{
You can opt-in or out to sending a measurement protocol hit when you load the package for use in the package's statistics via this function.  No personal data is collected.

If you opt in, \code{ga_trackme_event()} is the function that fires.  You can use \code{debug_call=TRUE} to see what would be sent before opting in or out.
}
\details{
Running \code{ga_trackme_event()} function will send a Measurement Protocol hit via \link{ga_mp_send} only if the \verb{~/.R/optin-googleanalyticsr} file is present
}
\examples{

# control your tracking choices via a menu if in interactive session
if(interactive()){
  ga_trackme()
}

# this only works with a valid opt-in file present 
ga_trackme_event()

# see what data is sent
ga_trackme_event(debug_call=TRUE)

# add your own message!
ga_trackme_event(debug_call = TRUE, say_hello = "err hello Mark")
}
