% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{met_filter}
\alias{met_filter}
\title{Make a metric filter object}
\usage{
met_filter(
  metric,
  operator = c("EQUAL", "LESS_THAN", "GREATER_THAN", "IS_MISSING"),
  comparisonValue,
  not = FALSE
)
}
\arguments{
\item{metric}{metric name to filter on.}

\item{operator}{How to match the dimension.}

\item{comparisonValue}{What to match.}

\item{not}{Logical NOT operator. Boolean.}
}
\value{
An object of class \code{met_fil_ga4} for use in \code{\link{filter_clause_ga4}}
}
\description{
Make a metric filter object
}
\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate,
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']

## create filters on metrics
mf <- met_filter("bounces", "GREATER_THAN", 0)
mf2 <- met_filter("sessions", "GREATER", 2)

## create filters on dimensions
df <- dim_filter("source","BEGINS_WITH","1",not = TRUE)
df2 <- dim_filter("source","BEGINS_WITH","a",not = TRUE)

## construct filter objects
fc2 <- filter_clause_ga4(list(df, df2), operator = "AND")
fc <- filter_clause_ga4(list(mf, mf2), operator = "AND")

## make v4 request
ga_data1 <- google_analytics_4(ga_id,
                               date_range = c("2015-07-30","2015-10-01"),
                               dimensions=c('source','medium'),
                               metrics = c('sessions','bounces'),
                               met_filters = fc,
                               dim_filters = fc2,
                               filtersExpression = "ga:source!=(direct)")

}

}
\seealso{
Other filter functions: 
\code{\link{dim_filter}()},
\code{\link{filter_clause_ga4}()}
}
\concept{filter functions}
