% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ga_users_delete}
\alias{ga_users_delete}
\title{Delete all user access for an email}
\usage{
ga_users_delete(email, accountId)
}
\arguments{
\item{email}{The email of the user to delete}

\item{accountId}{The accountId that the user will be deleted from including all web properties and Views underneath.}
}
\description{
This is a wrapper around calls to \link{ga_users_list} and \link{ga_users_delete_linkid}.  If you want more fine-grained control look at those functions.

The user email is deleted from all web properties and views underneath the accountId you provide.
}
\details{
This deletes a user via their email reference for all webproperties and views for the account given.
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()
ga_users_delete("brian@agency.com", 12345678)

# multiple emails
ga_users_delete(c("brian@agency.com", "bill@benland.com"), 1234567)

}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/accountUserLinks/delete}{Google Documentation}

Other User management functions: \code{\link{ga_users_add}},
  \code{\link{ga_users_delete_linkid}},
  \code{\link{ga_users_list}},
  \code{\link{ga_users_update}}
}
