% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{as.data.frame.git_tree}
\alias{as.data.frame.git_tree}
\title{Coerce entries in a git_tree to a \code{data.frame}}
\usage{
\method{as.data.frame}{git_tree}(x, ...)
}
\arguments{
\item{x}{The tree \code{object}}

\item{...}{Additional arguments. Not used.}
}
\value{
\code{data.frame}
}
\description{
The entries in a tree are coerced to a \code{data.frame}
}
\details{
The \code{data.frame} have the following columns:
\describe{

\item{filemode}{
    The UNIX file attributes of a tree entry
  }

\item{type}{
    String representation of the tree entry type
  }

\item{sha}{
    The sha of a tree entry
  }

\item{name}{
    The filename of a tree entry
  }

}
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
dir.create(file.path(path, "subfolder"))
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create three files and commit
writeLines("First file",  file.path(path, "example-1.txt"))
writeLines("Second file", file.path(path, "subfolder/example-2.txt"))
writeLines("Third file",  file.path(path, "example-3.txt"))
add(repo, c("example-1.txt", "subfolder/example-2.txt", "example-3.txt"))
commit(repo, "Commit message")

## Display tree
tree(last_commit(repo))

## Coerce tree to a data.frame
df <- as(tree(last_commit(repo)), "data.frame")
df
}
}
