% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{branch_delete}
\alias{branch_delete}
\alias{branch_delete,git_branch-method}
\title{Delete a branch}
\usage{
branch_delete(branch)

\S4method{branch_delete}{git_branch}(branch)
}
\arguments{
\item{branch}{The branch}
}
\value{
invisible NULL
}
\description{
Delete a branch
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")

## Create a 'dev' branch
dev <- branch_create(commit_1, name = "dev")
branches(repo)

## Delete 'dev' branch
branch_delete(dev)
branches(repo)
}
}
\keyword{methods}

