% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghistostats.R
\name{gghistostats}
\alias{gghistostats}
\title{Histogram for distribution of a numeric variable}
\usage{
gghistostats(
  data,
  x,
  binwidth = NULL,
  bar.measure = "count",
  xlab = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  type = "parametric",
  test.value = 0,
  bf.prior = 0.707,
  bf.message = TRUE,
  effsize.type = "g",
  conf.level = 0.95,
  nboot = 100,
  k = 2L,
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  bar.fill = "grey50",
  results.subtitle = TRUE,
  test.k = 0,
  test.value.line = FALSE,
  test.value.line.args = list(size = 1),
  test.value.label.args = list(size = 3),
  centrality.parameter = "mean",
  centrality.k = 2,
  centrality.line.args = list(size = 1, color = "blue"),
  centrality.label.args = list(color = "blue", size = 3),
  normal.curve = FALSE,
  normal.curve.args = list(size = 3),
  ggplot.component = NULL,
  output = "plot",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{A numeric variable from the dataframe \code{data}.}

\item{binwidth}{The width of the histogram bins. Can be specified as a
numeric value, or a function that calculates width from \code{x}. The default is
to use the \code{max(x) - min(x) / sqrt(N)}. You should always check this value
and explore multiple widths to find the best to illustrate the stories in
your data.}

\item{bar.measure}{Character describing what value needs to be represented as
height in the bar chart. This can either be \code{"count"}, which shows number
of points in bin, or \code{"density"}, which density of points in bin, scaled to
integrate to 1, or "\code{proportion}", which shows relative frequencies of
observations in each bin, or "\code{mix}", which shows \emph{both} count and
proportion in the same plot.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption.}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"d"} (for Cohen's \emph{d}) or \code{"g"} (for Hedge's \emph{g}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{bar.fill}{Character input that decides which color will uniformly fill
all the bars in the histogram (Default: \code{"grey50"}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{test.k}{Integer denoting the number of decimal places expected for
\code{test.value} label. (Default: \code{0} ).}

\item{test.value.line}{Logical that decides whether a line corresponding to
the \code{test.value} should be superimposed on the plot.}

\item{test.value.line.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}

\item{test.value.label.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}

\item{centrality.parameter}{Decides \emph{which} measure of central tendency
(\code{"mean"} or \code{"median"}) is to be displayed as a vertical line. To not show
any parameter, set this to \code{"none"}.}

\item{centrality.k}{Integer denoting the number of decimal places expected
for centrality parameter label. (Default: \code{2}).}

\item{centrality.line.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_line} used to display the
lines corresponding to the centrality parameter and test value.}

\item{centrality.label.args}{A list of additional
aesthetic arguments to be passed to the \code{geom_label} used to display the
label corresponding to the centrality parameter and test value.}

\item{normal.curve}{A logical value that decides whether to super-impose a
normal curve using \code{stats::dnorm(mean(x), sd(x))}. Default is \code{FALSE}.}

\item{normal.curve.args}{A list of additional aesthetic arguments to be
passed to the normal curve.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function.}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Currently ignored.}
}
\description{
Histogram with statistical details from one-sample test included
in the plot as a subtitle.
}
\examples{
\donttest{
# most basic function call with the defaults
# this is the **only** function where data argument can be `NULL`
ggstatsplot::gghistostats(
  data = ToothGrowth,
  x = len,
  xlab = "Tooth length",
  centrality.parameter = "median"
)

# a detailed function call
ggstatsplot::gghistostats(
  data = iris,
  x = Sepal.Length,
  bar.measure = "mix",
  type = "p",
  caption = substitute(paste(italic("Note"), ": Iris dataset by Fisher.")),
  bf.prior = 0.8,
  test.value = 3,
  test.value.line = TRUE,
  binwidth = 0.10,
  bar.fill = "grey50"
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/gghistostats.html}
}
\seealso{
\code{\link{grouped_gghistostats}}, \code{\link{ggdotplotstats}},
\code{\link{grouped_ggdotplotstats}}
}
