% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggcoefstats.R
\name{subtitle_meta_ggcoefstats}
\alias{subtitle_meta_ggcoefstats}
\title{Prepare subtitle with meta-analysis results}
\usage{
subtitle_meta_ggcoefstats(data, k = 2, messages = TRUE,
  output = "subtitle", ...)
}
\arguments{
\item{data}{A dataframe. It \strong{must} contain columns named \code{estimate}
(corresponding estimates of coefficients or other quantities of interest)
and \code{std.error} (the standard error of the regression term).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{output}{Character describing the desired output. If \code{"subtitle"}, a
formatted subtitle will be returned. The other option is to return \code{"tidy"}
data frame with coefficients.}

\item{...}{Additional arguments (ignored).}
}
\description{
Making text subtitle for meta-analysis via linear (mixed-effects)
models as implemented in the \code{metafor} package.
}
\examples{
# set up
set.seed(123)
library(ggstatsplot)
library(gapminder)

# saving results from regression
df_results <- purrr::pmap(
  .l = list(
    data = list(gapminder::gapminder),
    formula = list(scale(lifeExp) ~ scale(gdpPercap)),
    grouping.vars = alist(continent),
    output = list("tidy", "glance")
  ),
  .f = groupedstats::grouped_lm
) \%>\%
  dplyr::full_join(x = .[[1]], y = .[[2]], by = "continent") \%>\%
  dplyr::filter(.data = ., term != "(Intercept)")

# making subtitle
ggstatsplot::subtitle_meta_ggcoefstats(
  data = df_results,
  k = 3,
  messages = FALSE
)

# getting tidy data frame with coefficients
ggstatsplot::subtitle_meta_ggcoefstats(
  data = df_results,
  messages = FALSE,
  output = "tidy"
)
}
\author{
Indrajeet Patil
}
