% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_print.xtree.reg.R
\name{print.xtree.reg}
\alias{print.xtree.reg}
\title{Print function for the Pathmox Segmentation Trees: linear regression and LAD}
\usage{
\method{print}{xtree.reg}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.reg"}.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{print.xtree.reg} print the \code{reg.pathmox} tree
}
\examples{

 \dontrun{
##example of LM in alumni satisfaction
 
data(fibtelereg)

#identify the segmentation variables  
segvar = fibtelereg[,2:11]

#select the variables
data.fib = fibtelereg[,12:18]          

#re-ordering those segmentation variables with ordinal scale
segvar$Age     = factor(segvar$Age, ordered=T)
segvar$Salary   = factor(segvar$Salary, 
	levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
segvar$Accgrade = factor(segvar$Accgrade, 
	levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
segvar$Grade 	= factor(segvar$Grade, 
	levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=2,method="lm",size=0.15)

 print(fib.reg.pathmox)

}
data(fibtelereg)

#Identify the segmentation variables  
segvar= fibtelereg[1:50,3:4]

#Select the variables
data.fib=fibtelereg[1:50,12:18]          

fib.reg.pathmox=reg.pathmox(Satisfact~.,data=data.fib,segvar,
	signif=0.05,deep=1,method="lm",size=0.15)

print(fib.reg.pathmox)

}
\references{
Aluja, T. Lamberti, G. Sanchez, G. (2013). Modeling with heterogeneity. 
Meetings of Italian Statistical Society, Advances in Latent Variables - Methods, 
Models and Applications. Brescia.

Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.

Sanchez, G. (2009) \emph{PATHMOX Approach: Segmentation Trees in
Partial Least Squares Path Modeling.} PhD Dissertation. 

\code{\link{summary.xtree.pls}}.
}
\author{
Giuseppe Lamberti
}
