% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_b_metrics.R
\name{ba_b_metrics}
\alias{ba_b_metrics}
\title{ba_b_metrics}
\usage{
ba_b_metrics(forest_df, group_var, inv_time)
}
\arguments{
\item{forest_df}{Data frame containing the forest monitoring data.}

\item{group_var}{String. The name of the column used to group the data, that could be "plot" or "spp".}

\item{inv_time}{Numeric. The time interval between the two monitoring periods.}
}
\value{
A list containing:
\item{sur_gain}{Matrix of basal area gain for surviving trees by group.}
\item{sur_loss}{Matrix of basal area loss for surviving trees by group.}
\item{rec_ba}{Matrix of basal area for recruited trees by group.}
\item{death_ba}{Matrix of basal area for dead trees by group.}
\item{BA_gain}{Matrix of total basal area gain by group.}
\item{BA_loss}{Matrix of total basal area loss by group.}
\item{ba_n0}{Total basal area at time 0 by group.}
\item{ba_n1}{Total basal area at time 1 by group.}
\item{loss_rate_ba}{Numeric. The basal area loss rate (percent per year) by group.}
\item{gain_rate_ba}{Numeric. The basal area gain rate (percent per year) by group.}
\item{nc_rate_ba}{Numeric. The net change rate of basal area (percent per year) by group.}
\item{turn_ba}{Numeric. The turnover rate of basal area (average of loss and gain rates) by group.}
\item{biomass_n0}{Total above-ground biomass at time 0 by group.}
\item{biomass_n1}{Total above-ground biomass at time 1 by group.}
}
\description{
Computes basal area (BA) ans Biomass(B) metrics for forest monitoring by category over a specified time interval.
This function calculates BA and B metrics for specified groups in a dataset, including gains, losses,
recruitment, and mortality.
}
