% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fedstat_data_ids_filter.R
\name{fedstat_data_ids_filter}
\alias{fedstat_data_ids_filter}
\title{Filters \code{data_ids} based on \code{filters} that are given in JSON format}
\usage{
fedstat_data_ids_filter(data_ids, filters, disable_warnings = FALSE)
}
\arguments{
\item{data_ids}{data.frame, result of \code{fedstat_get_data_ids}
with or without conjunction with \code{fedstat_get_data_ids_special_cases_handle}}

\item{filters}{JSON in R list form. The structure should be like this:

\preformatted{
{
 "filter_field_title1": ["filter_value_title1", "filter_value_title2"],
 "filter_field_title2": ["filter_value_title1", "filter_value_title2"],
 ...
}
}

Where for example \code{filter_field_title1} could be a string "Year" with
\code{filter_value_title1} equal to 2020 and \code{filter_field_title2}
could be a string "OKATO" with \code{filter_value_title1}
equal to "Russian Federation"
Not actual filter field titles and filter values titles
because of ASCII requirement for CRAN}

\item{disable_warnings}{bool, enables or disables following warnings:
\enumerate{
\item About non matched \code{filter_value_title} in \code{filters} and \code{filter_value_title} from \code{data_ids};
\item About unspecified \code{filter_filed_title} in filters.
}}
}
\value{
data.frame, filtered \code{data_ids}
}
\description{
Filters indicator \code{data_ids} with given \code{filters}
taking into account possible \code{filters} specification errors and default filters.

\code{filters} should use \code{filter_field_title} in names and \code{filter_value_title} in values as
they are presented on fedstat.ru. If for some reason the specified filters
do not return the expected result, it is worth inspecting possible
filter values in \code{data_ids} to see if the strings are defined correctly
(e.g. encoding issues, mixing latin and cyrillic symbols)

\code{filter_value_title} currently supports the following special values:
\enumerate{
\item asterix (*), it's alias for "select all possible filter values for this filter field"
}

Unspecified filters use asterix as a default
(i.e. all possible filter values are selected and a warning is given)

Internally normalized \code{filter_field_title} and \code{filter_value_title} are
used (all lowercase, removed extra whitespaces)
to compare the equality of \code{data_ids} and \code{filters}
}
\examples{
\dontrun{
# Get data filters identificators for week prices
# standardize names for DVFO and extract week numbers
# filter the data_ids to get data for week 21 and 22 of 2021
# for all goods and services for Russian Federation
data_ids_filtered <- fedstat_get_data_ids("37426") \%>\%
  fedstat_get_data_ids_special_cases_handle(
    filter_value_title_alias_lookup_table = data.frame(
      "filter_value_title" = "Dalnevostochnyj federalnyj okrug ( s 03.11.2018)",
      "filter_value_title_alias" = "Dalnevostochnyj federalnyj okrug"
    )
  ) \%>\%
  fedstat_data_ids_filter(
    filters = list(
      "Territory" = "Russian Federation",
      "Year" = "2021",
      "Period" = c(21, 22),
      "Types of goods and services" = "*"
    )
  )

# In this example names for Far Eastern Federal District are latinized for CRAN
# Not actual filter field titles and filter values titles because of ASCII requirement for CRAN
}
}
\seealso{
\code{\link{fedstat_get_data_ids},
  \link{fedstat_post_data_ids_filtered}}
}
