# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title VaultConfiguration
#' @description VaultConfiguration Class
#' @format An \code{R6Class} generator object
#' @field name  character [optional]
#'
#' @field accounts  named list( \link{ConfigurationAccount} ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
VaultConfiguration <- R6::R6Class(
  'VaultConfiguration',
  public = list(
    `name` = NULL,
    `accounts` = NULL,
    initialize = function(`name`=NULL, `accounts`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`accounts`)) {
        stopifnot(is.vector(`accounts`), length(`accounts`) != 0)
        sapply(`accounts`, function(x) stopifnot(R6::is.R6(x)))
        self$`accounts` <- `accounts`
      }
    },
    toJSON = function() {
      VaultConfigurationObject <- list()
      if (!is.null(self$`name`)) {
        VaultConfigurationObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`accounts`)) {
        VaultConfigurationObject[['accounts']] <-
          lapply(self$`accounts`, function(x) x$toJSON())
      }

      VaultConfigurationObject
    },
    fromJSON = function(VaultConfigurationJson) {
      VaultConfigurationObject <- jsonlite::fromJSON(VaultConfigurationJson)
      if (!is.null(VaultConfigurationObject$`name`)) {
        self$`name` <- VaultConfigurationObject$`name`
      }
      if (!is.null(VaultConfigurationObject$`accounts`)) {
        self$`accounts` <- ApiClient$new()$deserializeObj(VaultConfigurationObject$`accounts`, "map(ConfigurationAccount)", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`accounts`)) {
        sprintf(
        '"accounts":
        %s
',
        jsonlite::toJSON(lapply(self$`accounts`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(VaultConfigurationJson) {
      VaultConfigurationObject <- jsonlite::fromJSON(VaultConfigurationJson)
      self$`name` <- VaultConfigurationObject$`name`
      self$`accounts` <- ApiClient$new()$deserializeObj(VaultConfigurationObject$`accounts`, "map(ConfigurationAccount)", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
