# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Columns operations
#' @description factset.analyticsapi.engines.Columns
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetPAColumnById } \emph{ Get PA column settings }
#' This endpoint returns the default settings of a PA column.
#'
#' \itemize{
#' \item \emph{ @param } id character
#' \item \emph{ @returnType } \link{Column} \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns settings of a PA column.
#'
#' \item return type : Column 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Age \tab Standard HTTP header. Header will specify the age of columns list cached response. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 400 | Invalid column Id.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 404 | Column not found.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' \strong{ GetPAColumns } \emph{ Get PA columns }
#' This endpoint lists all the PA columns that can be applied to a calculation.
#'
#' \itemize{
#' \item \emph{ @param } name character
#' \item \emph{ @param } category character
#' \item \emph{ @param } directory character
#' \item \emph{ @returnType } named list( \link{ColumnSummary} ) \cr
#'
#' \item On encountering errors, an error of subclass ApiException will be thrown.
#'
#' \item status code : 200 | Expected response, returns a list of PA columns
#'
#' \item return type : map(ColumnSummary) 
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' Age \tab Standard HTTP header. Header will specify the age of columns list cached response. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 401 | Missing or invalid authentication.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 403 | User is forbidden with current credentials
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 406 | Unsupported Accept header. Header needs to be set to application/json.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 500 | Server error. Log the X-DataDirect-Request-Key header to assist in troubleshooting
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' \item status code : 503 | Request timed out. Retry the request in sometime.
#'
#'
#' \item response headers :
#'
#' \tabular{ll}{
#' X-RateLimit-Remaining \tab Number of requests left for the time window. \cr
#' X-FactSet-Api-Request-Key \tab Key to uniquely identify an Analytics API request. Only available after successful authentication. \cr
#' X-RateLimit-Reset \tab Number of seconds remaining till rate limit resets. \cr
#' X-RateLimit-Limit \tab Number of allowed requests for the time window. \cr
#' X-DataDirect-Request-Key \tab FactSet&#39;s request key header. \cr
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetPAColumnById  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.id <- 'id_example' # character | Unique identifier for a column
#'
#' #Get PA column settings
#' api.instance <- ColumnsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetPAColumnById(var.id),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' ####################  GetPAColumns  ####################
#'
#' library(factset.analyticsapi.engines)
#' var.name <- 'name_example' # character | 
#' var.category <- 'category_example' # character | 
#' var.directory <- 'directory_example' # character | 
#'
#' #Get PA columns
#' api.instance <- ColumnsApi$new()
#'
#' #Configure HTTP basic authorization: Basic
#' # provide your username in the user-serial format
#' api.instance$apiClient$username <- '<user-serial>'; 
#' # provide your api key generated using the developer portal
#' api.instance$apiClient$password <- '<api_key>';
#'
#'result <- tryCatch(
#'             api.instance$GetPAColumns(name=var.name, category=var.category, directory=var.directory),
#'             ApiException = function(ex) ex 
#'          )
#' # In case of error, print the error object 
#' if(!is.null(result$ApiException)) {
#'   cat(result$ApiException$toString())
#' } else {
#' # deserialized response object
#' response.object <- result$content
#' # response headers
#' response.headers <- result$response$headers
#' # response status code
#' response.status.code <- result$response$status_code
#' }
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom caTools base64encode
#' @importFrom rlang abort
#' @export
ColumnsApi <- R6::R6Class(
  'ColumnsApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetPAColumnById = function(id, ...){
      apiResponse <- self$GetPAColumnByIdWithHttpInfo(id, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetPAColumnByIdWithHttpInfo = function(id, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (missing(`id`)) {
        rlang::abort(message = "Missing required parameter `id`.", .subclass = "ApiException", ApiException = ApiException$new(status = 0, reason = "Missing required parameter `id`."))
      }

      urlPath <- "/analytics/lookups/v2/engines/pa/columns/{id}"
      if (!missing(`id`)) {
        urlPath <- gsub(paste0("\\{", "id", "\\}"), URLencode(as.character(`id`), reserved = TRUE), urlPath)
      }

      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "Column", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    },
    GetPAColumns = function(name=NULL, category=NULL, directory=NULL, ...){
      apiResponse <- self$GetPAColumnsWithHttpInfo(name, category, directory, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetPAColumnsWithHttpInfo = function(name=NULL, category=NULL, directory=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      queryParams['name'] <- name

      queryParams['category'] <- category

      queryParams['directory'] <- directory

      urlPath <- "/analytics/lookups/v2/engines/pa/columns"
      # HTTP basic auth
      headerParams['Authorization'] <- paste("Basic", caTools::base64encode(paste(self$apiClient$username, self$apiClient$password, sep=":")), sep=" ")

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "map(ColumnSummary)", loadNamespace("factset.analyticsapi.engines")),
          error = function(e){
             rlang::abort(message = "Failed to deserialize response", .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- paste("Server returned " , httr::status_code(resp) , " response status code.")
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api client exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        errorMsg <- toString(content(resp))
        if(errorMsg == ""){
          errorMsg <- "Api server exception encountered."
        }
        rlang::abort(message = errorMsg, .subclass = "ApiException", ApiException = ApiException$new(http_response = resp))
      }
    }
  )
)
