# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title CalculationStatus
#' @description CalculationStatus Class
#' @format An \code{R6Class} generator object
#' @field status  character [optional]
#'
#' @field points  integer [optional]
#'
#' @field pa  named list( \link{CalculationUnitStatus} ) [optional]
#'
#' @field spar  named list( \link{CalculationUnitStatus} ) [optional]
#'
#' @field vault  named list( \link{CalculationUnitStatus} ) [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
CalculationStatus <- R6::R6Class(
  'CalculationStatus',
  public = list(
    `status` = NULL,
    `points` = NULL,
    `pa` = NULL,
    `spar` = NULL,
    `vault` = NULL,
    initialize = function(`status`=NULL, `points`=NULL, `pa`=NULL, `spar`=NULL, `vault`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`status`)) {
        stopifnot(is.character(`status`), length(`status`) == 1)
        self$`status` <- `status`
      }
      if (!is.null(`points`)) {
        stopifnot(is.numeric(`points`), length(`points`) == 1)
        self$`points` <- `points`
      }
      if (!is.null(`pa`)) {
        stopifnot(is.vector(`pa`), length(`pa`) != 0)
        sapply(`pa`, function(x) stopifnot(R6::is.R6(x)))
        self$`pa` <- `pa`
      }
      if (!is.null(`spar`)) {
        stopifnot(is.vector(`spar`), length(`spar`) != 0)
        sapply(`spar`, function(x) stopifnot(R6::is.R6(x)))
        self$`spar` <- `spar`
      }
      if (!is.null(`vault`)) {
        stopifnot(is.vector(`vault`), length(`vault`) != 0)
        sapply(`vault`, function(x) stopifnot(R6::is.R6(x)))
        self$`vault` <- `vault`
      }
    },
    toJSON = function() {
      CalculationStatusObject <- list()
      if (!is.null(self$`status`)) {
        CalculationStatusObject[['status']] <-
          self$`status`
      }
      if (!is.null(self$`points`)) {
        CalculationStatusObject[['points']] <-
          self$`points`
      }
      if (!is.null(self$`pa`)) {
        CalculationStatusObject[['pa']] <-
          lapply(self$`pa`, function(x) x$toJSON())
      }
      if (!is.null(self$`spar`)) {
        CalculationStatusObject[['spar']] <-
          lapply(self$`spar`, function(x) x$toJSON())
      }
      if (!is.null(self$`vault`)) {
        CalculationStatusObject[['vault']] <-
          lapply(self$`vault`, function(x) x$toJSON())
      }

      CalculationStatusObject
    },
    fromJSON = function(CalculationStatusJson) {
      CalculationStatusObject <- jsonlite::fromJSON(CalculationStatusJson)
      if (!is.null(CalculationStatusObject$`status`)) {
        self$`status` <- CalculationStatusObject$`status`
      }
      if (!is.null(CalculationStatusObject$`points`)) {
        self$`points` <- CalculationStatusObject$`points`
      }
      if (!is.null(CalculationStatusObject$`pa`)) {
        self$`pa` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`pa`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(CalculationStatusObject$`spar`)) {
        self$`spar` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`spar`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      }
      if (!is.null(CalculationStatusObject$`vault`)) {
        self$`vault` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`vault`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`status`)) {
        sprintf(
        '"status":
          "%s"
                ',
        self$`status`
        )},
        if (!is.null(self$`points`)) {
        sprintf(
        '"points":
          %d
                ',
        self$`points`
        )},
        if (!is.null(self$`pa`)) {
        sprintf(
        '"pa":
        %s
',
        jsonlite::toJSON(lapply(self$`pa`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )},
        if (!is.null(self$`spar`)) {
        sprintf(
        '"spar":
        %s
',
        jsonlite::toJSON(lapply(self$`spar`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )},
        if (!is.null(self$`vault`)) {
        sprintf(
        '"vault":
        %s
',
        jsonlite::toJSON(lapply(self$`vault`, function(x){ x$toJSON() }), auto_unbox = TRUE, digits=NA)
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(CalculationStatusJson) {
      CalculationStatusObject <- jsonlite::fromJSON(CalculationStatusJson)
      self$`status` <- CalculationStatusObject$`status`
      self$`points` <- CalculationStatusObject$`points`
      self$`pa` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`pa`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      self$`spar` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`spar`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      self$`vault` <- ApiClient$new()$deserializeObj(CalculationStatusObject$`vault`, "map(CalculationUnitStatus)", loadNamespace("factset.analyticsapi.engines"))
      self
    }
  )
)
