% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_style.R
\name{driver_team_lookup}
\alias{driver_team_lookup}
\alias{get_driver_abbreviation}
\alias{get_driver_name}
\alias{get_team_name}
\alias{get_drivers_by_team}
\alias{get_team_by_driver}
\alias{get_session_drivers_and_teams}
\title{Driver & Team Look-ups}
\usage{
get_driver_abbreviation(
  driver_name,
  season = get_current_season(),
  round = 1,
  session = "R"
)

get_driver_name(
  driver_name,
  season = get_current_season(),
  round = 1,
  session = "R"
)

get_team_name(team_name, season = get_current_season(), short = FALSE)

get_drivers_by_team(
  team_name,
  season = get_current_season(),
  round = 1,
  session = "R"
)

get_team_by_driver(
  driver_name,
  season = get_current_season(),
  round = 1,
  short = FALSE
)

get_session_drivers_and_teams(season, round, session = "R")
}
\arguments{
\item{driver_name}{Driver name (or unique part thereof) to look up.}

\item{season}{The season for which the look-up should occur. Should be a number from 2018 to current season.
Defaults to current season.}

\item{round}{number from 1 to 24 (depending on season selected) and defaults
to most recent. Also accepts race name.}

\item{session}{the code for the session to load. Options are \code{'FP1'}, \code{'FP2'}, \code{'FP3'},
\code{'Q'}, \code{'S'}, \code{'SS'},\code{'SQ'}, and \code{'R'}. Default is \code{'R'}, which refers to Race.}

\item{team_name}{The team name (as a string) to use for lookup.}

\item{short}{whether to provide a shortened version of the team name. Default False.}
}
\value{
for \code{get_session_drivers_and_teams()} a data.frame,
for \code{get_drivers_by_team()} a unnamed character vector with all drivers for the requested team,
for all other functions a character result with the requested value.
}
\description{
These functions provide the ability to look-up drivers or teams (and match the two) for given
races or seasons.

\code{get_driver_abbreviation()} looks up the driver abbreviation (typically 3 letters) as used in the provided season.

\code{get_team_name()} looks up the officially recorded team name based on fuzzy matching to the supplied string. This is
fairly inconsistent, for example, "Haas" is recorded as "Haas F1 Team", but not all sponsor names are recorded nor are
all names indicating 'F1 Team' --  "RB" is recorded as "RB" and not "Visa Cash App RB F1 Team". If \code{short = TRUE} then
a short form for the team is provided ("Haas" instead of "Haas F1 Team").

\code{get_driver_name()} looks up a driver's full name based on fuzzy matching to the supplied string. The driver has to
have participated in the session (season, round, session) for this to match properly. For full-time drivers this is
easy, but for rookies who do test FP1 this is a more important note.

\code{get_drivers_by_team()} looks up a team's drivers for the provided race session (season, round, session). If looking
for practice rookies, they typically participate in \code{session = FP1}.

\code{get_team_by_driver()} looks up the team for the specified driver (at the specified race event).

\code{get_session_drivers_and_teams()} returns a data frame of all drivers and their team for a provided session.
}
