% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.1-plCV.R
\name{plCV}
\alias{plCV}
\title{Perform Simple Cross-Validation}
\usage{
plCV(array, top, how, fold, ...)
}
\arguments{
\item{array}{Specifies the \code{ExprsArray} object to undergo cross-validation.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{how}{A character string. Specifies the \code{\link{build}} method to iterate.}

\item{fold}{A numeric scalar. Specifies the number of folds for cross-validation.
Set \code{fold = 0} to perform leave-one-out cross-validation.}

\item{...}{Arguments passed to the \code{how} method.}
}
\value{
A numeric scalar. The cross-validation accuracy.
}
\description{
Calculates v-fold or leave-one-out cross-validation without selecting a new
 set of features with each fold. See Details.
}
\details{
\code{plCV} performs v-fold or leave-one-out cross-validation. The argument
 \code{fold} specifies the number of v-folds to use during cross-validation.
 Set \code{fold = 0} to perform leave-one-out cross-validation. Cross-validation
 accuracy is defined as the average accuracy from \code{\link{calcStats}}.

This type of cross-validation is most appropriate if the data
 has not undergone any prior feature selection. However, it can also serve
 as an unbiased guide to parameter selection when embedded in
 \code{\link{plGrid}}. If using cross-validation in lieu of an independent test
 set in the setting of one or more feature selection methods, consider using
 a more "sophisticated" form of cross-validation as implemented in
 \code{\link{plMonteCarlo}} or \code{\link{plNested}}.

When calculating model performance with \code{\link{calcStats}}, this
 function forces \code{aucSkip = TRUE} and \code{plotSkip = TRUE}.
}
