% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block_maxima.R
\name{block_maxima}
\alias{block_maxima}
\title{Block maxima}
\usage{
block_maxima(data, block_length, block)
}
\arguments{
\item{data}{A numeric vector containing a time series of raw data.}

\item{block_length}{A numeric scalar. Used calculate the maxima of disjoint
blocks of \code{block_length} contiguous values in the vector \code{data}.
If \code{length(data)} is not an integer multiple of \code{block_length} then
the values at the end of \code{data} that do not constitute a complete block
of length \code{block_length} are discarded, without warning.}

\item{block}{A numeric vector with the same length as \code{data}. The value of
\code{block[i]} indicates the block into which \code{data[i]} falls. For example,
\code{block} could provide the year in which observation \code{i} was observed.}
}
\value{
A list, with class \code{c("list", "block_maxima", "evmissing")},
containing the following numeric vectors:
\itemize{
\item \code{maxima}: the block maxima.
\item \code{notNA}: the numbers of non-missing observations in each block.
\item \code{n}: the maximal block length, that is, the largest number of values that
could have been observed in each block.
}

If a block contains only missing values then its value of \code{maxima} is \code{NA}
and its value of \code{notNA} is \code{0}.

If \code{block} is supplied then these vectors are named using the values in
\code{block}. Otherwise, these vectors do not have names.
}
\description{
Extracts block maxima and the number of non-missing observations per block.
}
\details{
Exactly one of the arguments \code{block_length} or \code{block} must be
supplied.
}
\examples{
## Simulate example data
set.seed(7032025)
data <- rexp(15)

# Create some missing values
data[c(5, 7:8)] <- NA
# 5 blocks (columns), each with 3 observations
matrix(data, ncol = 5)
# Supplying block_length
block_length <- 3
block_maxima(data, block_length = block_length)
# Supplying block
block <- rep(1:5, each = 3)
block_maxima(data, block = block)

## Data with an incomplete block
data <- c(data, 1:2)

# Supplying block_length (the extra 2 observations are ignored)
block_length <- 3
block_maxima(data, block_length = block_length)
# Supplying block (with an extra group indicator)
block <- c(block, 7, 7)
block_maxima(data, block = block)
}
