% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_small_options.R
\name{merge_small_options}
\alias{merge_small_options}
\title{Merge small parties and/or candidates}
\usage{
merge_small_options(x, min.party, min.candidate)
}
\arguments{
\item{x}{A tibble with the same components and structure as the tibbles in the \code{ei.Datasets} package.
For instance, like the ei_NZ_2020 object.}

\item{min.party}{A number between 0 and 100. Those parties which individually did not reach
at least min.party\% of the election-district vote are grouped in the option
‘Other parties votes’.}

\item{min.candidate}{A number between 0 and 100. Those candidates which individually did not
reach at least min.candididate\% of the election-district vote are grouped
in the option ‘Other candidates votes’.}
}
\value{
A tibble similar to \code{x} with small parties and candidates merged on, respectively, ‘Other parties votes’
and ‘Other candidates votes’, with \code{min.party} and \code{min.candidate} used to determine when an electoral
option is small.
}
\description{
Merge small parties and also small candidates by, respectively, aggregating them
in the options 'Other parties votes' and 'Other candidates votes'.
}
\examples{
collapsed.tibble <- merge_small_options(x = ei_NZ_2020, min.party = 3, min.candidate = 5)

}
\references{
Pavia, JM (2021). ei.Datasets: Real datasets for assessing ecological inference algorithms, Social Science Computer Review, forthcoming.
}
\seealso{
\code{\link{ei_NZ_2002}} \code{\link{ei_NZ_2005}} \code{\link{ei_NZ_2008}}
\code{\link{ei_NZ_2011}} \code{\link{ei_NZ_2014}} \code{\link{ei_NZ_2017}}
\code{\link{ei_NZ_2020}} \code{\link{ei_SCO_2007}}
}
\author{
Jose M. Pavia, \email{jose.m.pavia@uv.es}
}
