% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{ComparePlot}
\alias{ComparePlot}
\title{A plot function to compare diferent eefAnalytics S3 objects from the eefAnalytics package.}
\usage{
ComparePlot(eefAnalyticsList, group = NULL, modelNames = NULL)
}
\arguments{
\item{eefAnalyticsList}{A list of eefAnalytics S3 objects from eefAnalytics package.}

\item{group}{a value indicating which intervention to plot.
This must not be greater than the number of intervention excluding the control group.
For a two arm trial, the maximum value is 1 and a maximum value of 2 for three arm trial.}

\item{modelNames}{a string factor containing the names of model to compare}
}
\value{
Returns a forest plot to compare the different models
}
\description{
A forest plot comparing the different eefAnalytics results.
}
\details{
\code{ComparePlot} produces a forest plot which compares the effect size and the associated confidence interval from the different model. 
For a multilevel model, it shows effect size based on residual variance and total variance.
}
\examples{
if(interactive()){

data(mstData)
###############
##### SRT #####
###############

outputSRT <- srtFREQ(Posttest~ Intervention + Prettest,
                     intervention = "Intervention", data = mstData)

outputSRTBoot <- srtFREQ(Posttest~ Intervention + Prettest,
                         intervention = "Intervention",nBoot=1000, data = mstData)

###############
##### MST #####
###############

outputMST <- mstFREQ(Posttest~ Intervention + Prettest, 
                     random = "School", intervention = "Intervention", data = mstData)

outputMSTBoot <- mstFREQ(Posttest~ Intervention + Prettest, 
                         random = "School", intervention = "Intervention", 
                         nBoot = 1000, data = mstData)

##################
##### Bayesian #####
##################

outputMSTbayes <- mlmBayes(Posttest~ Intervention + Prettest, 
                           random = "School", intervention = "Intervention",
                           nSim = 10000, data = mstData)


## comparing different results

ComparePlot(list(outputSRT,outputSRTBoot,outputMST,outputMSTBoot,outputMSTbayes),
            modelNames =c("ols", "olsBoot","MLM","MLMBoot","MLMBayes"),group=1)


}
}

