/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.table;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableColumnPacker {
    private static final int DEFAULT_MARGIN = 2;
    private static final int DEFAULT_MAXSCAN = 50;
    private int margin = 2;
    private int headerMargin = -1;
    private int maxscan = 50;

    public void packColumns(JTable table) {
        int width;
        TableColumnModel colModel = table.getColumnModel();
        int totalPreferredWidth = 0;
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>(table.getColumnCount());
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableColumn col = colModel.getColumn(c);
            columns.add(col);
            int width2 = this.preferredWidth(table, col, c);
            totalPreferredWidth += width2;
            col.setPreferredWidth(width2);
        }
        if (table.getAutoResizeMode() != 0 && (width = table.getWidth()) > 0 && totalPreferredWidth > table.getWidth()) {
            this.setWidth(columns, table.getWidth());
        }
    }

    private void setWidth(List columns, int width) {
        TableColumn col;
        ArrayList<TableColumn> remainingColumns = new ArrayList<TableColumn>();
        int colSize = width / columns.size();
        Iterator i = columns.iterator();
        while (i.hasNext()) {
            col = (TableColumn)i.next();
            int prefWidth = col.getPreferredWidth();
            if (prefWidth < colSize) {
                width -= prefWidth;
                continue;
            }
            remainingColumns.add(col);
        }
        if (remainingColumns.size() <= 0) {
            return;
        }
        if (remainingColumns.size() < columns.size()) {
            this.setWidth(remainingColumns, width);
        } else {
            i = remainingColumns.iterator();
            while (i.hasNext()) {
                col = (TableColumn)i.next();
                col.setPreferredWidth(colSize);
            }
        }
    }

    private int preferredWidth(JTable table, TableColumn col, int vColIndex) {
        Component comp;
        TableCellRenderer renderer;
        int r;
        int width = 0;
        int rowCount = table.getRowCount();
        int stop = this.maxscan > 0 ? Math.min(this.maxscan, rowCount) : 0;
        int start = this.maxscan > 0 ? Math.max(rowCount - this.maxscan, stop) : rowCount;
        for (r = 0; r < stop; ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        for (r = start; r < rowCount; ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        width += 2 * this.margin;
        TableCellRenderer renderer2 = col.getHeaderRenderer();
        if (renderer2 == null) {
            renderer2 = table.getTableHeader().getDefaultRenderer();
        }
        int m = this.headerMargin < 0 ? this.margin : this.headerMargin;
        comp = renderer2.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = Math.max(width, comp.getPreferredSize().width + 2 * m);
        return width;
    }

    public int getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(int headerMargin) {
        this.headerMargin = headerMargin;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public int getMaxscan() {
        return this.maxscan;
    }

    public void setMaxscan(int maxscan) {
        this.maxscan = maxscan;
    }
}

