/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.DonneeParse;
import ihm.Gestionnaire;
import ihm.IHM;
import ihm.PanelHabillage;
import ihm.PanelHabillageIndividus;
import ihm.PanelHabillageModalites;
import ihm.PanelHabillageVariables;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class FenetreHabillage
extends JDialog {
    private Gestionnaire m_gestionnaire;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JTabbedPane jTabbedPane = null;
    private JPanel m_panelOkAnnuler = null;
    private JPanel m_panelSSOkAnnuler = null;
    private JButton m_btOk = null;
    private JButton m_btAnnuler = null;

    public FenetreHabillage(Frame owner, Gestionnaire gestionnaire) {
        super(owner);
        this.m_gestionnaire = gestionnaire;
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(IHM.getXmlLangue().getElement("Mhabillage"));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jContentPane.add((Component)this.getJTabbedPane(), null);
            this.jContentPane.add((Component)this.getPanelOkAnnuler(), null);
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            if (this.m_gestionnaire.getType() == 0) {
                if (this.m_gestionnaire.getDon().getType() != DonneeParse.TypeAnalyse.CA) {
                    this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabInd"), new PanelHabillageIndividus(this.m_gestionnaire));
                }
                if (this.m_gestionnaire.isModalitesVisibles()) {
                    this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabMod"), new PanelHabillageModalites(this.m_gestionnaire));
                }
            } else if (this.m_gestionnaire.getType() == 1) {
                this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabVar"), new PanelHabillageVariables(this.m_gestionnaire, 2));
            } else if (this.m_gestionnaire.getType() == 3) {
                this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabAxesPart"), new PanelHabillageVariables(this.m_gestionnaire, 3));
            } else if (this.m_gestionnaire.getType() == 4) {
                this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabInd"), new PanelHabillageIndividus(this.m_gestionnaire));
                if (this.m_gestionnaire.isModalitesVisibles()) {
                    this.jTabbedPane.add(IHM.getXmlLangue().getElement("MtypeHabMod"), new PanelHabillageModalites(this.m_gestionnaire));
                }
            }
        }
        return this.jTabbedPane;
    }

    private JPanel getPanelOkAnnuler() {
        if (this.m_panelOkAnnuler == null) {
            this.m_panelOkAnnuler = new JPanel();
            this.m_panelOkAnnuler.setLayout(new BorderLayout());
            this.m_panelOkAnnuler.add((Component)this.getPanelSSOkAnnuler(), "East");
        }
        return this.m_panelOkAnnuler;
    }

    private JPanel getPanelSSOkAnnuler() {
        if (this.m_panelSSOkAnnuler == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(8, 8, 8, 8);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(8, 8, 8, 8);
            this.m_panelSSOkAnnuler = new JPanel();
            this.m_panelSSOkAnnuler.setLayout(new GridBagLayout());
            this.m_panelSSOkAnnuler.add((Component)this.getBtOk(), gridBagConstraints6);
            this.m_panelSSOkAnnuler.add((Component)this.getBtAnnuler(), gridBagConstraints7);
        }
        return this.m_panelSSOkAnnuler;
    }

    private JButton getBtOk() {
        if (this.m_btOk == null) {
            this.m_btOk = new JButton();
            this.m_btOk.setText(IHM.getXmlLangue().getElement("Lok"));
            this.m_btOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Component[] tab;
                    Component[] componentArray = tab = FenetreHabillage.this.jTabbedPane.getComponents();
                    int n = tab.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component component = componentArray[n2];
                        if (component instanceof PanelHabillage) {
                            PanelHabillage panel = (PanelHabillage)component;
                            FenetreHabillage.this.m_gestionnaire.setHabillage(panel.getType(), panel.getHabillageDiscret());
                            FenetreHabillage.this.m_gestionnaire.setHabillage(panel.getType(), panel.getHabillageContinu(), panel.getStyleHabillageContinu());
                        }
                        ++n2;
                    }
                    FenetreHabillage.this.m_gestionnaire.sauverAnnotations();
                    FenetreHabillage.this.m_gestionnaire.updateGraphe();
                    FenetreHabillage.this.getJDialog().dispose();
                }
            });
        }
        return this.m_btOk;
    }

    private JButton getBtAnnuler() {
        if (this.m_btAnnuler == null) {
            this.m_btAnnuler = new JButton();
            this.m_btAnnuler.setText(IHM.getXmlLangue().getElement("Lannuler"));
            this.m_btAnnuler.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FenetreHabillage.this.getJDialog().dispose();
                }
            });
        }
        return this.m_btAnnuler;
    }

    protected JDialog getJDialog() {
        return this;
    }
}

