% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dkborder}
\alias{dkborder}
\title{dkborder}
\usage{
dkborder(mesh)
}
\arguments{
\item{mesh}{object of class mesh3d}
}
\value{
A vector of indices corresponding to the triangles with at least one vertex on the border of the mesh.
}
\description{
Selects the border of a 3d triangle mesh.
}
\examples{
border <- dkborder(dkmodel$cusp)

# Map the border in orange:
is_border <- rep(1, Rvcg::nfaces(dkmodel$cusp))
is_border[border] <- 2
dkmap(dkmodel$cusp, is_border, col = c("white", "#E69F00"), col.levels = 2, legend = FALSE,
scalebar = FALSE)

# Compare with vcgBorder from the R package Rvcg, in blue:
vcgborder <- which(Rvcg::vcgBorder(dkmodel$cusp)$borderit == TRUE)
is_border[vcgborder] <- 3
dkmap(dkmodel$cusp, is_border, col = c("white", "#E69F00", "#56B4E9"), col.levels = 3,
legend = FALSE, scalebar = FALSE)
#As you can see, it all depends on what you want to select!

}
