% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_helpers.R
\name{get_RUN_R_TESTS}
\alias{get_RUN_R_TESTS}
\title{Get System Variable RUN_R_TESTS}
\usage{
get_RUN_R_TESTS(stop_on_failure = FALSE)
}
\arguments{
\item{stop_on_failure}{Throw an error instead of returning 
\code{\link{FALSE}} if RUN_R_TESTS is not set or cannot be converted to
boolean.}
}
\value{
The value RUN_R_TESTS is set to, converted to boolean.
\code{\link{FALSE}} if RUN_R_TESTS is not set or cannot be converted to
boolean.
}
\description{
Convenience wrapper to \code{\link{Sys.getenv}}.
}
\details{
As \code{\link{Sys.getenv}} seems to always return a character vector, the
\code{\link{class}} of the value you set it to does not matter.
}
\examples{
set_RUN_R_TESTS("", force = TRUE) # make sure it is not set.
try(get_RUN_R_TESTS())
set_RUN_R_TESTS("A", force = TRUE) # "A" is not boolean.
try(get_RUN_R_TESTS())
set_RUN_R_TESTS(4213, force = TRUE) # All numbers apart from 0 are TRUE
get_RUN_R_TESTS()
set_RUN_R_TESTS("0", force = TRUE) # 0 (and "0") is FALSE
get_RUN_R_TESTS()
set_RUN_R_TESTS("FALSE", force = TRUE)
get_RUN_R_TESTS()
set_RUN_R_TESTS(TRUE, force = TRUE)
get_RUN_R_TESTS()
}
\keyword{internal}
