% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anti_join.r, R/full_join.r, R/inner_join.r,
%   R/left_join.r, R/semi_join.r
\name{anti_join.disk.frame}
\alias{anti_join.disk.frame}
\alias{full_join.disk.frame}
\alias{inner_join.disk.frame}
\alias{left_join.disk.frame}
\alias{semi_join.disk.frame}
\title{Performs join/merge for disk.frames}
\usage{
\method{anti_join}{disk.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  ...,
  outdir = tempfile("tmp_disk_frame_anti_join"),
  merge_by_chunk_id = FALSE,
  overwrite = TRUE,
  .progress = FALSE
)

\method{full_join}{disk.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  ...,
  outdir = tempfile("tmp_disk_frame_full_join"),
  overwrite = TRUE,
  merge_by_chunk_id,
  .progress = FALSE
)

\method{inner_join}{disk.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE,
  outdir = tempfile("tmp_disk_frame_inner_join"),
  merge_by_chunk_id = NULL,
  overwrite = TRUE,
  .progress = FALSE
)

\method{left_join}{disk.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = FALSE,
  outdir = tempfile("tmp_disk_frame_left_join"),
  merge_by_chunk_id = FALSE,
  overwrite = TRUE,
  .progress = FALSE
)

\method{semi_join}{disk.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  ...,
  outdir = tempfile("tmp_disk_frame_semi_join"),
  merge_by_chunk_id = FALSE,
  overwrite = TRUE,
  .progress = FALSE
)
}
\arguments{
\item{x}{a disk.frame}

\item{y}{a data.frame or disk.frame. If data.frame then returns lazily; if disk.frame it performs the join eagerly and return a disk.frame}

\item{by}{join by}

\item{copy}{same as dplyr::anti_join}

\item{...}{same as dplyr's joins}

\item{outdir}{output directory for disk.frame}

\item{merge_by_chunk_id}{the merge is performed by chunk id}

\item{overwrite}{overwrite output directory}

\item{.progress}{Show progress or not. Defaults to FALSE}

\item{suffix}{see dplyr::XXX_join}

\item{keep}{see dplyr::XXX_join}
}
\value{
disk.frame or data.frame/data.table
}
\description{
Performs join/merge for disk.frames
}
\examples{
df.df = as.disk.frame(data.frame(x = 1:3, y = 4:6), overwrite = TRUE)
df2.df = as.disk.frame(data.frame(x = 1:2, z = 10:11), overwrite = TRUE)

anti_joined.df = anti_join(df.df, df2.df) 

anti_joined.df \%>\% collect

anti_joined.data.frame = anti_join(df.df, data.frame(x = 1:2, z = 10:11))

# clean up
delete(df.df)
delete(df2.df)
delete(anti_joined.df)
cars.df = as.disk.frame(cars)

join.df = full_join(cars.df, cars.df, merge_by_chunk_id = TRUE)

# clean up cars.df
delete(cars.df)
delete(join.df)
cars.df = as.disk.frame(cars)

join.df = inner_join(cars.df, cars.df, merge_by_chunk_id = TRUE)

# clean up cars.df
delete(cars.df)
delete(join.df)
cars.df = as.disk.frame(cars)

join.df = left_join(cars.df, cars.df)

# clean up cars.df
delete(cars.df)
delete(join.df)
cars.df = as.disk.frame(cars)

join.df = semi_join(cars.df, cars.df)

# clean up cars.df
delete(cars.df)
delete(join.df)
}
