% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen.R
\name{generate_discrete_data}
\alias{generate_discrete_data}
\title{generate_discrete_data}
\usage{
generate_discrete_data(graph, params, n, ivn = NULL, ivn.rand = TRUE,
  n_levels = NULL)
}
\arguments{
\item{graph}{A \code{\link[sparsebnUtils]{edgeList}} object.}

\item{params}{Coefficient list.}

\item{n}{Size of the data set, a scalar}

\item{ivn}{List of interventions.}

\item{ivn.rand}{If \code{TRUE}, random values will be drawn uniformly for each intervention. Otherwise, these values need to supplied manually in \code{ivn}.}

\item{n_levels}{A vector of number of levels for each node. Default is binary data.}
}
\value{
data matrix
}
\description{
data generating function
}
\examples{

### generate observational data
gr <- sparsebnUtils::random.graph(5, 5) # use sparsebnUtils package to generate a random graph
names(gr) = c("V1", "V2", "V3", "V4", "V5")
nlevels <- c(3, 5, 2, 2, 3)
gr.params <- coef_gen(edge_list = gr, n_levels = nlevels)
data.obs <- discretecdAlgorithm::generate_discrete_data(graph = gr,
                                                        n = 100,
                                                        n_levels = nlevels,
                                                        params = gr.params)

### generate experimental data
ivn <- as.list(c(rep("V1", 50), rep("V2", 50))) # 50 interventions on V1, 50 interventions on V2
data.ivn <- discretecdAlgorithm::generate_discrete_data(graph = gr,
                                             n = 100,
                                             n_levels = nlevels,
                                             params = gr.params,
                                             ivn = ivn)

###  Use pre-specified values for interventions
###  In this toy example, we assume that all intervened nodes were fixed to
###  to the value 1, although this can be any number of course.
ivn.vals <- lapply(ivn, function(x) sapply(x, function(x) 1)) # replace all entries with a 1
data.ivn <- discretecdAlgorithm::generate_discrete_data(graph = gr,
                                             n = 100,
                                             n_levels = nlevels,
                                             params = gr.params,
                                             ivn = ivn.vals,
                                             ivn.rand = FALSE)

}
