% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplacian_heat_diffusion.R
\docType{methods}
\name{laplacian.heat.diffusion}
\alias{laplacian.heat.diffusion}
\alias{laplacian.heat.diffusion,numeric,matrix-method}
\title{Graph diffusion using a heat diffusion process on a Laplacian matrix.}
\usage{
laplacian.heat.diffusion(h0, graph, t = 0.5, ...)

\S4method{laplacian.heat.diffusion}{numeric,matrix}(h0, graph, t = 0.5, ...)
}
\arguments{
\item{h0}{an \code{n}-dimensional numeric non-negative vector of starting temperatures}

\item{graph}{an (\code{n x n})-dimensional numeric non-negative adjacence matrix representing the graph}

\item{t}{time point when heat is measured}

\item{...}{additional parameters}
}
\value{
returns the heat on every node as numeric vector
}
\description{
An amount of starting heat gets distribution using the Laplacian matrix of a graph.
Every iteration (or time interval) \code{t} heat streams from the starting nodes into surrounding nodes.
}
\examples{
# count of nodes
n <- 5
# starting distribution (has to sum to one)
h0 <- as.vector(rmultinom(1, 1, prob=rep(.2, n)))
# adjacency matrix (either normalized or not)
graph <- matrix(abs(rnorm(n*n)), n, n)
# computation of stationary distribution
ht <- laplacian.heat.diffusion(h0, graph)
}
\references{
\url{https://en.wikipedia.org/wiki/Laplacian_matrix} \cr
\url{https://en.wikipedia.org/wiki/Heat_equation}
}
