% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{tag_f}
\alias{cont_f}
\alias{div_f}
\alias{div_f,}
\alias{span_f}
\alias{span_f,}
\alias{tag_f}
\title{Make Functions That Wrap Text in HTML Tags}
\usage{
tag_f(tag, class = character(), style = character())

div_f(class = character(), style = character())

span_f(class = character(), style = character())

cont_f(class = character())
}
\arguments{
\item{tag}{character(1L) a name of an HTML tag}

\item{class}{character the CSS class(es)}

\item{style}{named character inline styles, where the name is the CSS
property and the value the value.}
}
\value{
a function that accepts a character parameter.  If applied, each
  element in the character vector will be wrapped in the div tags
}
\description{
Helper functions to generate functions to use as slots for the
\code{StyleHtml@funs} classes.  These are functions that return
\emph{functions}.
}
\details{
\code{tag_f} and related functions (\code{div_f}, \code{span_f}) produce
functions that are  vectorized and will apply opening and closing tags to
each element of a character vector.  \code{container_f} on the other hand
produces a function will collapse a character vector into length 1, and only
then applies the tags.  Additionally, \code{container_f} already comes with
the \dQuote{diffobj_container} class specified.
}
\note{
inputs are assumed to be valid class names or CSS styles.
}
\examples{
## Assuming class 'ex1' has CSS styles defined elsewhere
tag_f("div", "ex1")(LETTERS[1:5])
## Use convenience function, and add some inline styles
div_f("ex2", c(color="green", `font-family`="arial"))(LETTERS[1:5])
## Notice how this is a div with pre-specifed class,
## and only one div is created around the entire data
cont_f()(LETTERS[1:5])
}

