% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aov.R
\name{estimate_aov_time}
\alias{estimate_aov_time}
\title{Execution Time Estimation for Factorial Simulations}
\usage{
estimate_aov_time(tree, test_runs = 50)
}
\arguments{
\item{tree}{\code{Tree} object upon which the simulations are performed.}

\item{test_runs}{\code{numeric} denoting the number of simulations utilized
for estimating the execution time. Default value is set to \code{50}.}
}
\value{
A \code{character} string, with estimated execution time (in minutes)
}
\description{
Estimates the expected execution time for a given number of factorial
simulations using the duration taken to run a sample subset of simulations.
}
\examples{
tree <- dexisensitivity::masc2
subtree <- create_sub_tree(tree, "Dimension sociale")
estimate_aov_time(subtree, test_runs = 50)

}
