% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{db_compute_raster}
\alias{db_compute_raster}
\alias{db_compute_raster2}
\title{Aggregates intersections of two variables}
\usage{
db_compute_raster(data, x, y, fill = n(), resolution = 100,
  complete = FALSE)

db_compute_raster2(data, x, y, fill = n(), resolution = 100,
  complete = FALSE)
}
\arguments{
\item{data}{A table (tbl)}

\item{x}{A continuous variable}

\item{y}{A continuous variable}

\item{fill}{The aggregation formula. Defaults to count (n)}

\item{resolution}{The number of bins created by variable. The highest the number, the more records
can be potentially imported from the source}

\item{complete}{Uses tidyr::complete to include empty bins. Inserts value of 0.}
}
\description{
To visualize two continuous variables, we typically resort to a Scatter plot. However,
this may not be practical when visualizing millions or billions of dots representing the
intersections of the two variables. A Raster plot may be a better option,
because it concentrates the intersections into squares that are easier to parse visually.

Uses very generic dplyr code to aggregate data.  Because of this approach,
the calculations automatically run inside the database if `data` has
a database or sparklyr connection. The `class()` of such tables
in R are: tbl_sql, tbl_dbi, tbl_sql
}
\details{
There are two considerations when using a Raster plot with a database. Both considerations are related
to the size of the results downloaded from the database:

- The number of bins requested: The higher the bins value is, the more data is downloaded from the database.

- How concentrated the data is: This refers to how many intersections return a value. The more
intersections without a value, the less data is downloaded from the database.
}
\examples{

library(dplyr)

# Returns a 100x100 grid of record count of intersections of eruptions and waiting
faithful \%>\%
  db_compute_raster(eruptions, waiting)

# Returns a 50x50 grid of eruption averages of intersections of eruptions and waiting
faithful \%>\%
  db_compute_raster(eruptions, waiting, fill = mean(eruptions), resolution = 50)

}
