% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{drug_products}
\alias{drug_products}
\title{Drug Products parser}
\usage{
drug_products(
  save_table = FALSE,
  save_csv = FALSE,
  csv_path = ".",
  override_csv = FALSE,
  database_connection = NULL
)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}

\item{save_csv}{boolean, save csv version of parsed tibble if true}

\item{csv_path}{location to save csv files into it, default is current
location, save_csv must be true}

\item{override_csv}{override existing csv, if any, in case it is true in the
new parse operation}

\item{database_connection}{DBI connection object that holds a connection to
user defined database. If \code{save_table} is enabled without providing
value for this function an error will be thrown.}
}
\value{
a tibble with 32 variables:
\describe{
 \item{name}{The proprietary name(s) provided by the manufacturer for any
 commercially available products containing this drug.}
 \item{labeller}{The corporation responsible for labelling this product.}
 \item{ndc-id}{The National Drug Code (NDC) identifier of the drug}
 \item{ndc-product-code}{The National Drug Code (NDC) product code from the
  FDA National Drug Code directory.}
 \item{dpd-id}{Drug Product Database (DPD) identification number (a.k.a. DIN)
  from the Canadian Drug Product Database. Only present for drugs that are
  marketed in Canada}
 \item{ema-product-code}{EMA product code from the European Medicines Agency
 Database. Only present for products that are authorised by central procedure
  for marketing in the European Union.}
 \item{ema-ma-number}{EMA marketing authorisation number from the European
 Medicines Agency Database. Only present for products that are authorised by
  central procedure for marketing in the European Union.}
 \item{started-marketing-on}{The starting date for market approval.}
 \item{ended-marketing-on}{The ending date for market approval.}
 \item{dosage-form	}{The pharmaceutical formulation by which the drug is
 introduced into the body.}
 \item{strength}{The amount of active drug ingredient provided in the dosage}
 \item{route}{The path by which the drug or product is taken into the body}
 \item{fda-application-number}{The New Drug Application [NDA] number
 assigned to this drug by the FDA.}
 \item{over-the-counter}{A list of Over The Counter (OTC) forms of the drug.}
 \item{generic}{Whether this product is a generic drug.}
 \item{approved}{Indicates whether this drug has been approved by the
 regulating government.}
 \item{country}{The country where this commercially available drug has been
 approved.}
 \item{source}{Source of this product information. For example, a value of
 DPD indicates this information was retrieved from the Canadian Drug Product
  Database.}
 \item{standing}{One of good, discordant, or deprecated. Distinguishes
 products with up to date ingredient information (good) from products with
 conflicting information (discordant) or products that have been removed from
  an active label (deprecated).}
 \item{standing-updated-on}{The date on which the standing was last updated}
 \item{standing-reason}{Explains the non-good standing of the product.
 One of: ingredient_change, code_duplication, invalid, or removed.}
 \item{jurisdiction-marketing-category	}{The marketing category of this
 product in its jurisdiction}
 \item{branded}{Whether this product has a named brand}
 \item{prescription}{Whether this product is only available with
 a prescription}
 \item{unapproved}{Whether this product is not approved in its jurisdiction}
 \item{vaccine}{Whether this product is a vaccine}
 \item{allergenic}{Whether this product is used in allergenic testing}
 \item{cosmetic}{Whether this product is a cosmetic, such as sunscreen}
 \item{kit}{Whether this product is a kit composed of multiple distinct
 parts}
 \item{solo}{Whether this product has only a single active ingredient}
 \item{available}{Whether this product can be sold in its jurisdiction}
 \item{\emph{drugbank_id}}{drugbank id}
}
}
\description{
A list of commercially available products in Canada and the United States
 that contain the drug.
}
\section{read_drugbank_xml_db}{

\code{\link{read_drugbank_xml_db}} function must be called first before any
parser.

If \code{\link{read_drugbank_xml_db}} is called before for any reason, so
no need to call it again before calling this function.
}

\examples{
\dontrun{
# the same parameters and usage will be applied for any parser
# return only the parsed tibble
run_all_parsers()

# will throw an error, as database_connection is NULL
run_all_parsers(save_table = TRUE)

# save in database in SQLite in memory database and return parsed tibble
sqlite_con <- DBI::dbConnect(RSQLite::SQLite())
run_all_parsers(save_table = TRUE, database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in current location,
# and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_csv = TRUE)

# save in database, save parsed tibble as csv,
# if it does not exist in current location and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_table = TRUE, save_csv = TRUE,
database_connection = sqlite_con)

# save parsed tibble as csv if it does not exist in given location,
# and return parsed tibble.
# if the csv exist before read it and return its data.
run_all_parsers(save_csv = TRUE, csv_path = TRUE)

# save parsed tibble as csv if it does not exist in current location and
# return parsed tibble.
# if the csv exist override it and return it.
run_all_parsers(save_csv = TRUE, csv_path = TRUE, override = TRUE)
}
}
\seealso{
Other drugs: 
\code{\link{drug_affected_organisms}()},
\code{\link{drug_ahfs_codes}()},
\code{\link{drug_atc_codes}()},
\code{\link{drug_calc_prop}()},
\code{\link{drug_categories}()},
\code{\link{drug_classification}()},
\code{\link{drug_dosages}()},
\code{\link{drug_ex_identity}()},
\code{\link{drug_exp_prop}()},
\code{\link{drug_external_links}()},
\code{\link{drug_food_interactions}()},
\code{\link{drug_general_information}()},
\code{\link{drug_groups}()},
\code{\link{drug_interactions}()},
\code{\link{drug_intern_brand}()},
\code{\link{drug_manufacturers}()},
\code{\link{drug_mixtures}()},
\code{\link{drug_packagers}()},
\code{\link{drug_patents}()},
\code{\link{drug_pdb_entries}()},
\code{\link{drug_pharmacology}()},
\code{\link{drug_prices}()},
\code{\link{drug_reactions_enzymes}()},
\code{\link{drug_reactions}()},
\code{\link{drug_salts}()},
\code{\link{drug_sequences}()},
\code{\link{drug_snp_adverse_reactions}()},
\code{\link{drug_snp_effects}()},
\code{\link{drug_syn}()}
}
\concept{drugs}
