% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_datetimeoffset.r
\name{as_datetimeoffset}
\alias{as_datetimeoffset}
\alias{as_datetimeoffset.datetimeoffset}
\alias{as_datetimeoffset.Date}
\alias{as_datetimeoffset.default}
\alias{as_datetimeoffset.POSIXt}
\alias{as_datetimeoffset.character}
\alias{as_datetimeoffset.nanotime}
\alias{as_datetimeoffset.partial_time}
\alias{as_datetimeoffset.clock_year_month_day}
\alias{as_datetimeoffset.clock_year_month_weekday}
\alias{as_datetimeoffset.clock_iso_year_week_day}
\alias{as_datetimeoffset.clock_year_quarter_day}
\alias{as_datetimeoffset.clock_year_day}
\alias{as_datetimeoffset.clock_naive_time}
\alias{as_datetimeoffset.clock_sys_time}
\alias{as_datetimeoffset.clock_zoned_time}
\title{Coerce to "datetimeoffset" objects}
\usage{
as_datetimeoffset(x, ...)

\method{as_datetimeoffset}{datetimeoffset}(x, ...)

\method{as_datetimeoffset}{Date}(x, tz = NA_character_, ...)

\method{as_datetimeoffset}{default}(x, ...)

\method{as_datetimeoffset}{POSIXt}(x, ...)

\method{as_datetimeoffset}{character}(x, tz = NA_character_, ...)

\method{as_datetimeoffset}{nanotime}(x, tz = "GMT", ...)

\method{as_datetimeoffset}{partial_time}(x, ...)

\method{as_datetimeoffset}{clock_year_month_day}(x, ...)

\method{as_datetimeoffset}{clock_year_month_weekday}(x, ...)

\method{as_datetimeoffset}{clock_iso_year_week_day}(x, ...)

\method{as_datetimeoffset}{clock_year_quarter_day}(x, ...)

\method{as_datetimeoffset}{clock_year_day}(x, ...)

\method{as_datetimeoffset}{clock_naive_time}(x, ...)

\method{as_datetimeoffset}{clock_sys_time}(x, ...)

\method{as_datetimeoffset}{clock_zoned_time}(x, ...)
}
\arguments{
\item{x}{An R object that can reasonably be coerced to a \code{\link[=datetimeoffset]{datetimeoffset()}} object
such as a string in pdfmark date or ISO 8601 datetime formats
or something with an \code{\link[=as.POSIXct]{as.POSIXct()}} method.}

\item{...}{Further arguments to certain methods.}

\item{tz}{Time zone to use for the conversion.
Ignored by \code{as_datetimeoffset.Date()}.
Generally need not be a single value.}
}
\value{
A \code{\link[=datetimeoffset]{datetimeoffset()}} vector
}
\description{
\code{as_datetimeoffset()} coerces to \code{\link[=datetimeoffset]{datetimeoffset()}} objects.
}
\examples{
# ISO 8601 examples
as_datetimeoffset("2020-05-15")
as_datetimeoffset("20200515")
as_datetimeoffset("2020-05-15T08:23:16")
as_datetimeoffset("20200515T082316")
as_datetimeoffset("2020-05-15T08:23:16.003Z")
as_datetimeoffset("20200515T082316Z")
as_datetimeoffset("2020-05-15T08:23:16+03:30")
as_datetimeoffset("20200515T082316+0330")

# Misc supported `as.POSIXlt()` `tryFormats` examples
as_datetimeoffset("2020/05/15 08:23:16")

# pdfmark datetime examples
as_datetimeoffset("D:20200515")
as_datetimeoffset("D:20200515082316")
as_datetimeoffset("D:20200515082316+03'30'")

as_datetimeoffset(Sys.time())
}
