% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_na_to.R
\name{convert_na_to}
\alias{convert_na_to}
\alias{convert_na_to.numeric}
\alias{convert_na_to.character}
\alias{convert_na_to.data.frame}
\title{Replace missing values in a variable or a dataframe.}
\usage{
convert_na_to(x, ...)

\method{convert_na_to}{numeric}(x, replacement = NULL, verbose = TRUE, ...)

\method{convert_na_to}{character}(x, replacement = NULL, verbose = TRUE, ...)

\method{convert_na_to}{data.frame}(
  x,
  replace_num = NULL,
  replace_char = NULL,
  replace_fac = NULL,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{A numeric, factor, or character vector, or a data frame.}

\item{...}{Not used.}

\item{replacement}{Numeric or character value that will be used to
replace \code{NA}.}

\item{verbose}{Toggle warnings.}

\item{replace_num}{Value to replace \code{NA} when variable is of type numeric.}

\item{replace_char}{Value to replace \code{NA} when variable is of type character.}

\item{replace_fac}{Value to replace \code{NA} when variable is of type factor.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item or one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")}.
}

If \code{NULL}, selects all columns.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}
}
\value{
\code{x}, where \code{NA} values are replaced by \code{replacement}.
}
\description{
Replace missing values in a variable or a dataframe.
}
\examples{
# Convert NA to 0 in a numeric vector
convert_na_to(
  c(9, 3, NA, 2, 3, 1, NA, 8),
  replacement = 0
)

# Convert NA to "missing" in a character vector
convert_na_to(
  c("a", NA, "d", "z", NA, "t"),
  replacement = "missing"
)

### For dataframes

test_df <- data.frame(
  x = c(1, 2, NA),
  x2 = c(4, 5, NA),
  y = c("a", "b", NA)
)

# Convert all NA to 0 in numeric variables, and all NA to "missing" in
# character variables
convert_na_to(
  test_df,
  replace_num = 0,
  replace_char = "missing"
)

# Convert a specific variable in the dataframe
convert_na_to(
  test_df,
  replace_num = 0,
  replace_char = "missing",
  select = "x"
)

# Convert all variables starting with "x"
convert_na_to(
  test_df,
  replace_num = 0,
  replace_char = "missing",
  select = starts_with("x")
)

# Convert NA to 1 in variable 'x2' and to 0 in all other numeric
# variables
convert_na_to(
  test_df,
  replace_num = 0,
  select = list(x2 = 1)
)

}
