% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNode.R
\name{updateObject}
\alias{updateObject}
\alias{updateObject,MNode-method}
\title{Update an object on a Member Node, by creating a new object that replaces an original.}
\usage{
updateObject(x, ...)

\S4method{updateObject}{MNode}(x, pid, file = as.character(NA), newpid, sysmeta, dataobj = NULL)
}
\arguments{
\item{x}{The MNode instance on which the object will be created}

\item{...}{(Not yet used.)}

\item{pid}{The identifier of the object to be updated}

\item{file}{the absolute file location of the object to be uploaded}

\item{newpid}{The identifier of the new object to be created}

\item{sysmeta}{a SystemMetadata instance describing properties of the object}

\item{dataobj}{a \code{raw} object to use for the upload, instead of the contents of the \code{file} argument.}
}
\value{
A \code{character} containing the identifier if successful.
}
\description{
This method provides the ability to update a data or metadata object to the Member Node
provided in the \code{'x'} parameter.  In DataONE, both the original object and the new object are
maintained, each with its own persistent identifier, and the 'obsoletes' field in the SystemMetadata is
used to reflect the fact that the new object replaces the old.  Both objects remain accessible.
}
\details{
In the version 2.0 library and higher, this operation can utilize an 
'dataone_token' option to provide credentials for write operations in DataONE.
The authentication token is obtained from DataONE (see your profile on https://search.dataone.org).
See the \code{vignette("dataone-overview")} for details.
Alternatively, the version 1.0 approach of using an X.509 certificate in a default location of the file 
system can also be used. This certificate provides authentication credentials from 
CILogon \url{https://cilogon.org/?skin=DataONE}.  See \code{vignette("dataone-overview")} for details.
}
\note{
Please see the vignette *upload-data* for an example: \code{vignette("upload-data")}
}
\seealso{
\url{https://purl.dataone.org/architecture/apis/MN_APIs.html#MNStorage.update}
}
