% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\name{hasReservation}
\alias{hasReservation}
\alias{hasReservation,CNode-method}
\title{Checks to determine if the supplied subject is the owner of the reservation of id.}
\usage{
hasReservation(x, ...)

\S4method{hasReservation}{CNode}(x, pid, subject = as.character(NA))
}
\arguments{
\item{x}{A CNode instance.}

\item{...}{Additional parameters.}

\item{pid}{The identifier that is being checked for existing as a reserved identifier or is in use as 
an identifier for an existing object}

\item{subject}{The subject of the principal (user) that made the reservation.}
}
\value{
A logical value where TRUE means a reservation exists for the specified pid by the subject.
}
\description{
The hasReservation method checks the reservation of an identifier that has
previously been reserved with the \code{reserveIdentifier} method. The identifier must have
been reserved by the specified DataONE user identity (\code{subject}).
}
\details{
To determine the DataONE identity that is currently being used for DataONE
authentication, use the \code{echoCredentials} method.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("STAGING")
creds <- echoCredentials(cn)
subject <- creds$person$subject
# Previously reserved pid (using reserveIdentifeir()), e.g. DOI or uuid
pid <- "urn:node:e27bb4f3-96bb-4af4-8902-f5914def077c"
hasRes <- hasReservation(cn, pid, subject=subject)
}
}
\seealso{
\code{\link[=CNode-class]{CNode}}{ class description.}
}
