% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Client.R
\docType{class}
\name{D1Client-class}
\alias{D1Client-class}
\title{The D1Client class contains methods that perform high level DataONE tasks}
\description{
The methods in the D1Client class call the low level DataONE API to
perform involved tasks such as uploading all the packages in a DataPackage (i.e
\code{\link{uploadDataPackage}})
}
\section{Slots}{

\describe{
\item{\code{cn}}{The Coordinating Node associated with the D1Client object}

\item{\code{mn}}{The Member Node associated with this D1Client object}
}}

\section{Methods}{

\itemize{
 \item{\code{\link{D1Client}}}{: Construct a D1Client object.}
 \item{\code{\link{convert.csv}}}{: Convert a DataFrame to Standard CSV.}
 \item{\code{\link{createDataPackage}}}{: Create a DataPackage on a DataONE Member Node.}
 \item{\code{\link{encodeUrlPath}}}{: Encode the Input for a URL Path Segment.}
 \item{\code{\link{encodeUrlQuery}}}{: Encode the Input for a URL Query Segment.}
 \item{\code{\link{getDataObject}}}{: Download a single data object from a DataONE Federation member node.}
 \item{\code{\link{getDataPackage}}}{: Download a collection of data object from the DataONE Federation member node as a DataPackage.}
 \item{\code{\link{getEndpoint}}}{: Return the URL endpoint for the DataONE Coordinating Node.}
 \item{\code{\link{getMetadataMember}}}{: Get the DataObject containing package metadata.}
 \item{\code{\link{getMNodeId}}}{: Get the member node identifier associated with this D1Client object.}
 \item{\code{\link{listMemberNodes}}}{: List DataONE Member Nodes.}
 \item{\code{\link{reserveIdentifier}}}{: Reserve a unique identifier in the DataONE Network.}
 \item{\code{\link{uploadDataObject}}}{: Upload a DataObject to a DataONE member node.}
 \item{\code{\link{uploadDataPackage}}}{: Upload a DataPackage to a DataONE member node.}
}
}

\seealso{
\code{\link{dataone}}{ package description.}
}
