% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getWaterML1Data}
\alias{getWaterML1Data}
\title{Function to return data from the NWISWeb WaterML1.1 service}
\usage{
getWaterML1Data(obs_url)
}
\arguments{
\item{obs_url}{string containing the url for the retrieval}
}
\value{
mergedDF a data frame containing columns agency, site, dateTime, values, and remark codes for all requested combinations
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate.
}
\examples{
siteNumber <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- '00003'
property <- '00060'
urlBase <- "http://waterservices.usgs.gov/nwis"
obs_url <- constructNWISURL(siteNumber,property,startDate,endDate,'dv')
data <- getWaterML1Data(obs_url)
urlMulti <- constructNWISURL("04085427",c("00060","00010"),
            startDate,endDate,'dv',statCd=c("00003","00001"))
multiData <- getWaterML1Data(urlMulti)
groundWaterSite <- "431049071324301"
startGW <- "2013-10-01"
endGW <- "2014-06-30"
groundwaterExampleURL <- constructNWISURL(groundWaterSite, NA,
          startGW,endGW, service="gwlevels", format="xml",interactive=FALSE)
groundWater <- getWaterML1Data(groundwaterExampleURL)
unitDataURL <- constructNWISURL(siteNumber,property,
         "2014-10-10","2014-10-10",'uv',format='xml')
unitData <- getWaterML1Data(unitDataURL)
}

