% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFromFactor.R
\name{build_target_encoding}
\alias{build_target_encoding}
\title{Build target encoding}
\usage{
build_target_encoding(
  dataSet,
  cols_to_encode,
  target_col,
  functions = "mean",
  verbose = TRUE
)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols_to_encode}{columns to aggregate according to (list)}

\item{target_col}{column to aggregate (character)}

\item{functions}{functions of aggregation (list or character, default to "mean")}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
A \code{list} of \code{\link{data.table}} a data.table for each \code{cols_to_encode}
each data.table containing a line by unique value of column and \code{len(functions) + 1} columns.
}
\description{
Target encoding is the process of replacing a categorical value with the aggregation of the  
target variable. \code{build_target_encoding} is used to compute aggregations.
}
\examples{
# Build a data set
require(data.table)
dataSet <- data.table(student = c("Marie", "Marie", "Pierre", "Louis", "Louis"), 
                      grades = c(1, 1, 2, 3, 4))

# Perform target_encoding construction
build_target_encoding(dataSet, cols_to_encode = "student", target_col = "grades", 
                      functions = c("mean", "sum"))
}
