% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_conversion.R
\name{ToNewick}
\alias{ToNewick}
\title{Write a \code{data.tree} structure to Newick notation}
\usage{
ToNewick(node, heightAttribute = DefaultPlotHeight, ...)
}
\arguments{
\item{node}{The root \code{Node} of a tree or sub-tree to be converted}

\item{heightAttribute}{The attribute (field name, method, or function) storing or calculating the height for each \code{Node}}

\item{...}{parameters that will be passed on the the heightAttributeName, in case it is a function}
}
\description{
To read from Newick, you can use the \code{ape} package, and convert the resulting \code{phylo}
object to a \code{data.tree} structure.
}
\examples{
data(acme)
ToNewick(acme)
ToNewick(acme, heightAttribute = NULL)
ToNewick(acme, heightAttribute = function(x) DefaultPlotHeight(x, 200))
ToNewick(acme, rootHeight = 200)

}
\seealso{
Other Conversions from Node: 
\code{\link{as.dendrogram.Node}()}
}
\concept{Conversions from Node}
\keyword{Newick}
