% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{wide2long}
\alias{wide2long}
\title{Translate wide output format (e.g. from ode) into long format}
\usage{
wide2long(out, keep = 1, na.rm = FALSE)
}
\arguments{
\item{out}{data.frame or matrix or list of matrices in wide format}

\item{keep}{Index vector, the columns to keep}

\item{na.rm}{Logical, if \code{TRUE}, missing values are removed in the long format.}
}
\value{
data.frame in long format, i.e. columns "time" (out[,1]), "name" (colnames(out[,-1])), 
"value" (out[,-1]) and, if out was a list, "condition" (names(out))
}
\description{
Translate wide output format (e.g. from ode) into long format
}
\details{
The function assumes that out[,1] represents a time-like vector
whereas out[,-1] represents the values. Useful for plotting with ggplot. If 
a list is supplied, the names of the list are added as extra column names "condition"
}

