% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolsMarcus.R
\name{steadyStates}
\alias{steadyStates}
\title{Calculate analytical steady states}
\usage{
steadyStates(model, file = NULL, smatrix = NULL, states = NULL,
  rates = NULL, forcings = NULL, givenCQs = NULL, neglect = NULL,
  sparsifyLevel = 2, outputFormat = "R")
}
\arguments{
\item{model}{Either name of the csv-file or the eqnlist of the model. If NULL, specify smatrix, states and rates by hand.}

\item{file}{Name of the file to which the steady-state equations are saved.
Read this file with \code{\link{readRDS}}.}

\item{smatrix}{Numeric matrix, stiochiometry matrix of the system}

\item{states}{Character vector, state vector of the system}

\item{rates}{Character vector, flux vector of the system}

\item{forcings}{Character vector with the names of the forcings}

\item{givenCQs}{Character vector with conserved quantities. Use the format c("A + pA = totA", "B + pB = totB"). If NULL, conserved quantities are automatically calculated.}

\item{neglect}{Character vector with names of states and parameters that must not be used for solving the steady-state equations}

\item{sparsifyLevel}{numeric, Upper bound for length of linear combinations used for simplifying the stoichiometric matrix}

\item{outputFormat}{Define the output format. By default "R" generating dMod 
compatible output. To obtain an output appropriate for d2d [1] "M" must be 
selected.}
}
\value{
Character vector of steady-state equations.
}
\description{
Calculate analytical steady states
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
\references{
[1]
\url{https://bitbucket.org/d2d-development/d2d-software/wiki/Home}
}

