% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{unique}
\alias{unique}
\alias{unique,CppForwardList-method}
\alias{unique,CppList-method}
\title{Delete consecutive duplicates}
\usage{
unique(x, incomparables, ...)
}
\arguments{
\item{x}{A CppForwardList or CppList object.}

\item{incomparables}{Ignored.}

\item{...}{Ignored.}
}
\value{
Returns the number of deleted elements.
}
\description{
Erases consecutive duplicated values from the container by reference.
}
\details{
Duplicated, non-consecutive elements are not removed.

\code{incomparables} and \code{...} are only included for compatibility with the generic \code{base::unique} method and have no effect.
}
\examples{
l <- cpp_forward_list(c(4, 5, 6, 6, 4))
l
# 4 5 6 6 4

unique(l)
# [1] 1
l
# 4 5 6 4

}
\seealso{
\link{erase}, \link{remove.}, \link{sort}.
}
