% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{theme_map}
\alias{theme_map}
\title{Create a theme for map plotting}
\usage{
theme_map(base_size = 14, base_family = "")
}
\arguments{
\item{base_size}{Overall font size. Default is 14.}

\item{base_family}{Base font family.}
}
\value{
The theme.
}
\description{
The theme created by this function is useful for plotting maps with cowplot default sizing.
}
\examples{
usa_data = map_data("usa")
ggplot(usa_data, aes(long, lat, group=region)) + geom_polygon() + theme_map()
ggplot(usa_data, aes(long, lat, fill = region)) + geom_polygon() + theme_map()
ggplot(usa_data, aes(long, lat, fill = region)) + facet_wrap(~region, scales = "free") +
  geom_polygon() + theme_map()
}
