% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot_grid}
\alias{plot_grid}
\title{Arrange multiple plots into a grid}
\usage{
plot_grid(..., plotlist = NULL, nrow = NULL, ncol = NULL, scale = 1,
  labels = NULL, label_size = 14, cols = NULL, rows = NULL)
}
\arguments{
\item{...}{List of plots to be arranged into the grid.}

\item{plotlist}{(optional) List of plots to display. Alternatively, the plots can be provided
individually as the first n arguments of the function plot_grid (see examples).}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{ncol}{(optional) Number of columns in the plot grid.}

\item{scale}{(optional) Allows to set an overall scaling of each sub-plot. Can be set separately for
each subplot, by giving a vector of scale values, or at once for all subplots,
by giving a single value.}

\item{labels}{(optional) List of labels to be added to the plots.}

\item{label_size}{(optional) Numerical value indicating the label size. Default is 14.
#'}

\item{cols}{Deprecated. Like \code{ncol}.}

\item{rows}{Deprecated. Like \code{nrow}.}
}
\description{
Arrange multiple plots into a grid.
}
\examples{
p1 <- qplot(1:10, 1:10)
p2 <- qplot(1:10, (1:10)^2)
p3 <- qplot(1:10, (1:10)^3)
p4 <- qplot(1:10, (1:10)^4)
plot_grid(p1, p2, p3, p4)
plot_grid(p1, p2, p3, p4, labels=c('A', 'B', 'C', 'D'))
plot_grid(p1, p2, p3, nrow=3, labels=c('A', 'B', 'C', 'D'), label_size=12)
plot_grid(p1, NULL, NULL, p2, p3, NULL, ncol=2,
 labels=c('A', 'B', 'C', 'D', 'E', 'F'), label_size=12)
}

